#!/bin/sh

. /etc/.mbinfo

HTML_PAGE="../setup_about.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

NET_DEVICE="eth0"

NAME="`uname -n`"
VERSIONOS="`cat /usr/local/etc/.version 2>/dev/null`"
VERSIONBOOT="`cat /etc/.version 2>/dev/null`"
VERSIONHW="$HW_Version"
MODULNO="$Module_No"
PCBNO="$PCB_No"
MAC="`/sbin/ifconfig $NET_DEVICE | grep 'HWaddr' | sed s/'^.*HWaddr '//`"
OS="`uname -o | sed s/'\/'/'%%'/`"
CPU="`cat /proc/cpuinfo | grep -a \"Processor\" | sed s/'^.*: '//`"
MEM="`cat /proc/meminfo | grep -a \"MemTotal\" | sed s/'^.*  '//` \/ `cat /proc/meminfo | grep -a \"MemFree\" | sed s/'^.*  '//`"
UPTIME="`uptime | sed s/'.*up '/''/ | sed s/',.*'/''/`"
BKLTIME="`/sbin/bklmon -i | grep 'Lifetime:' | awk '{print $2 " h " $4 " m"}'`"

if [ ! "$VERSIONOS" ]; then
    VERSIONOS="UNKNOWN"
fi

if [ ! "$VERSIONBOOT" ]; then
    VERSIONBOOT="UNKNOWN"
fi

if [ ! "$VERSIONHW" ]; then
    VERSIONHW="UNKNOWN"
fi

if [ ! "$MODULNO" ]; then
    MODULNO="UNKNOWN"
fi

if [ ! "$PCBNO" ]; then
    PCBNO="UNKNOWN"
fi

if [ "$MINIBROWSER" ]; then
    echo "NAME=$NAME"
    echo "VERSIONOS=$VERSIONOS"
    echo "VERSIONBOOT=$VERSIONBOOT"
    echo "VERSIONHW=$VERSIONHW"
    echo "MODULNO=$MODULNO"
    echo "PCBNO=$PCBNO"
    echo "MAC=$MAC"
    echo "OS=`echo $OS | sed s/'%%'/'\/'/`"
    echo "CPU=$CPU"
    echo "MEM=`echo $MEM | sed s/'\\\'/''/`"
    echo "UPTIME=$UPTIME"
    echo "BKLTIME=$BKLTIME"
else
    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed s/'$NAME'/"$NAME"/g | sed s/'$VERSIONOS'/"$VERSIONOS"/g | sed s/'$VERSIONBOOT'/"$VERSIONBOOT"/g  \
        	   | sed s/'$VERSIONHW'/"$VERSIONHW"/g | sed s/'$MODULNO'/"$MODULNO"/g | sed s/'$PCBNO'/"$PCBNO"/g | sed s/'$MAC'/"$MAC"/g \
        	   | sed s/'$OS'/"$OS"/g | sed s/'$CPU'/"$CPU"/g | sed s/'$MEM'/"$MEM"/g | sed s/'$UPTIME'/"$UPTIME"/g | sed s/'$BKLTIME'/"$BKLTIME"/g \
        	   | sed s/'%%'/'\/'/g
fi
