#!/bin/sh

HTML_PAGE="../setup_network.html"

#echo "Content-type: text/html"
#echo

NET_DEVICE="eth0"

NET_CONFIG="/etc/network/interfaces"
DNS_CONFIG="/etc/resolv.conf"
MIB_CONFIG="/opt/MiniBrowser/MiniBrowser.ini"

DATA="`cat | sed s/'\&'/' '/g`"

#echo $DATA

DHCP="`echo $DATA | sed s/' '/'\n'/g | grep DHCP | sed s/'^.*='/''/`"

PLC_IP_1="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_1 | sed s/'^.*='/''/`"
PLC_IP_2="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_2 | sed s/'^.*='/''/`"
PLC_IP_3="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_3 | sed s/'^.*='/''/`"
PLC_IP_4="`echo $DATA | sed s/' '/'\n'/g | grep PLC_IP_4 | sed s/'^.*='/''/`"

PLCCOMS_IP_1="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMS_IP_1 | sed s/'^.*='/''/`"
PLCCOMS_IP_2="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMS_IP_2 | sed s/'^.*='/''/`"
PLCCOMS_IP_3="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMS_IP_3 | sed s/'^.*='/''/`"
PLCCOMS_IP_4="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMS_IP_4 | sed s/'^.*='/''/`"

PLCCOMS_PORT="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMS_PORT | sed s/'^.*='/''/`"

IP_1="`echo $DATA | sed s/' '/'\n'/g | grep '^IP_1' | sed s/'^.*='/''/`"
IP_2="`echo $DATA | sed s/' '/'\n'/g | grep '^IP_2' | sed s/'^.*='/''/`"
IP_3="`echo $DATA | sed s/' '/'\n'/g | grep '^IP_3' | sed s/'^.*='/''/`"
IP_4="`echo $DATA | sed s/' '/'\n'/g | grep '^IP_4' | sed s/'^.*='/''/`"

MASK_1="`echo $DATA | sed s/' '/'\n'/g | grep MASK_1 | sed s/'^.*='/''/`"
MASK_2="`echo $DATA | sed s/' '/'\n'/g | grep MASK_2 | sed s/'^.*='/''/`"
MASK_3="`echo $DATA | sed s/' '/'\n'/g | grep MASK_3 | sed s/'^.*='/''/`"
MASK_4="`echo $DATA | sed s/' '/'\n'/g | grep MASK_4 | sed s/'^.*='/''/`"

GW_1="`echo $DATA | sed s/' '/'\n'/g | grep GW_1 | sed s/'^.*='/''/`"
GW_2="`echo $DATA | sed s/' '/'\n'/g | grep GW_2 | sed s/'^.*='/''/`"
GW_3="`echo $DATA | sed s/' '/'\n'/g | grep GW_3 | sed s/'^.*='/''/`"
GW_4="`echo $DATA | sed s/' '/'\n'/g | grep GW_4 | sed s/'^.*='/''/`"

DNS1_1="`echo $DATA | sed s/' '/'\n'/g | grep DNS1_1 | sed s/'^.*='/''/`"
DNS1_2="`echo $DATA | sed s/' '/'\n'/g | grep DNS1_2 | sed s/'^.*='/''/`"
DNS1_3="`echo $DATA | sed s/' '/'\n'/g | grep DNS1_3 | sed s/'^.*='/''/`"
DNS1_4="`echo $DATA | sed s/' '/'\n'/g | grep DNS1_4 | sed s/'^.*='/''/`"

DNS2_1="`echo $DATA | sed s/' '/'\n'/g | grep DNS2_1 | sed s/'^.*='/''/`"
DNS2_2="`echo $DATA | sed s/' '/'\n'/g | grep DNS2_2 | sed s/'^.*='/''/`"
DNS2_3="`echo $DATA | sed s/' '/'\n'/g | grep DNS2_3 | sed s/'^.*='/''/`"
DNS2_4="`echo $DATA | sed s/' '/'\n'/g | grep DNS2_4 | sed s/'^.*='/''/`"

#echo "<P>IP = $IP_1.$IP_2.$IP_3.$IP_4</P>"

TMP_CONFIG=`cat $NET_CONFIG`

if [ "$DHCP" = "yes" ]; then
#    echo "<P>YES</P>"

    TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^ iface $NET_DEVICE inet static.*"/" iface $NET_DEVICE inet dhcp"/`
else
#    echo "<P>NO</P>"

    TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^ iface $NET_DEVICE inet dhcp.*"/" iface $NET_DEVICE inet static"/`

    if [ "$IP_1" -a "$IP_2" -a "$IP_3" -a "$IP_4" ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^.*address .*"/"     address $IP_1.$IP_2.$IP_3.$IP_4"/ \
            			       | sed s/"^.*network .*"/"     network $IP_1.$IP_2.$IP_3.0"/ \
                		       | sed s/"^.*broadcast .*"/"     broadcast $IP_1.$IP_2.$IP_3.255"/`
    else
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^.*address"/"#     address"/ \
            			       | sed s/"^.*network"/"#     network"/ \
                		       | sed s/"^.*broadcast"/"#     broadcast"/`
    fi

    if [ "$MASK_1" -a "$MASK_2" -a "$MASK_3" -a "$MASK_4" ]; then
	true
    else
	MASK_1="255"
	MASK_2="255"
	MASK_3="255"
	MASK_4="0"
    fi

    TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^.*netmask .*"/"     netmask $MASK_1.$MASK_2.$MASK_3.$MASK_4"/`

    if [ "$GW_1" -a "$GW_2" -a "$GW_3" -a "$GW_4" ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^.*gateway .*"/"     gateway $GW_1.$GW_2.$GW_3.$GW_4"/`
    else
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^.*gateway"/"#     gateway"/`
    fi

    if [ "$DNS1_1" -a "$DNS1_2" -a "$DNS1_3" -a "$DNS1_4" ]; then
	echo "nameserver $DNS1_1.$DNS1_2.$DNS1_3.$DNS1_4"  > $DNS_CONFIG
    else
	echo -n > $DNS_CONFIG
    fi
    if [ "$DNS2_1" -a "$DNS2_2" -a "$DNS2_3" -a "$DNS2_4" ]; then
	echo "nameserver $DNS2_1.$DNS2_2.$DNS2_3.$DNS2_4" >> $DNS_CONFIG
    fi
fi

echo "$TMP_CONFIG" > $NET_CONFIG

TMP_CONFIG=`cat $MIB_CONFIG | sed '/^\[plc\]/,/ip/d'`

if [ "$PLC_IP_1" -a "$PLC_IP_2" -a "$PLC_IP_3" -a "$PLC_IP_4" ]; then
    TMP_CONFIG=`echo ""; echo "[plc]" ; echo -n "ip                             = $PLC_IP_1.$PLC_IP_2.$PLC_IP_3.$PLC_IP_4" ; echo "$TMP_CONFIG"`
    echo "$TMP_CONFIG" > $MIB_CONFIG
fi

TMP_CONFIG=`cat $MIB_CONFIG | sed '/^\[server\]/,/^$/d'`

if [ "$PLCCOMS_IP_1" -a "$PLCCOMS_IP_2" -a "$PLCCOMS_IP_3" -a "$PLCCOMS_IP_4" -a "$PLCCOMS_PORT" ]; then
    SRV_CONFIG=`echo -n "\[server\]\n"; \
		echo -n "ip                             = $PLCCOMS_IP_1.$PLCCOMS_IP_2.$PLCCOMS_IP_3.$PLCCOMS_IP_4\n"; \
		echo -n "port                           = $PLCCOMS_PORT\n"; \
		echo -n "\n"; \
		echo -n "\[browser\]"`

    TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/"^\[browser\]"/"$SRV_CONFIG"/`

    echo "$TMP_CONFIG" > $MIB_CONFIG
fi

ifdown $NET_DEVICE >/dev/null 2>&1

#sleep 1

#/sbin/killall dhclient >/dev/null 2>&1
#/sbin/killall udhcpc >/dev/null 2>&1

sleep 1

ifup $NET_DEVICE >/dev/null 2>&1 &

if [ ! "$MINIBROWSER" ]; then
    killall MiniBrowser >/dev/null 2>&1
fi

sleep 1

sh setup_network.cgi
