#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
fi

HTML_PAGE="../setup_display.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

if [ -r /etc/default/xserver ]; then
	. /etc/default/xserver
fi

if [ "$XSERVER_ROTATION" = "" ]; then
    XSERVER_ROTATION="0"
fi

MIB_DIR="/opt/MiniBrowser"
MIB_CONFIG="${MIB_DIR}/MiniBrowser.ini"

#SCRSAVER="`xset -display :0 q | grep timeout | sed s/'^.*t:  '/''/ | sed s/' .*'/''/`"
#SCRSAVER="`expr $SCRSAVER \/ 60`"
SCRSAVER="$XSERVER_TIMEOUT"
BRIGHTNESS="`backlight | grep 'LCD brightness' | sed s/'^.*brightness '/''/ | sed s/'%.'/''/`"

SKIN_PATH="$(sed '/\[browser\]/,/^$/!d/^skin_path/!ds/^.*= //g' "$MIB_CONFIG")"
SKIN_FILE_NAME="$(sed '/\[browser\]/,/^$/!d/^skin_file_name/!ds/^.*= //g' "$MIB_CONFIG")"

DIALOG_THEME="$(basename "$SKIN_FILE_NAME")"
DIALOG_THEME="${DIALOG_THEME%%.skn}"
DIALOG_THEME_LIST="$(ls ${MIB_DIR}/${SKIN_PATH}/*.skn)"

DIALOG_THEME_OPTION="<OPTION>${DIALOG_THEME}<\/OPTION>"

IFS=$'\n'
for i in ${DIALOG_THEME_LIST}; do
    i=$(basename $i)
    i=${i%%.skn}
    if [ "$i" != "$DIALOG_THEME" ]; then
	DIALOG_THEME_OPTION="${DIALOG_THEME_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

PROJECT_SCALING="$(sed -n '/\[browser\]/,/^$/p' "$MIB_CONFIG" | awk '/^project_scaling/{print $3}')"
PROJECT_SCALING_LIST="none auto 0.5 0.62 0.8 1.25 1.6 2.0"

PROJECT_SCALING_OPTION="<OPTION>${PROJECT_SCALING}<\/OPTION>"

IFS=' '
for i in ${PROJECT_SCALING_LIST}; do
    if [ "$i" != "$PROJECT_SCALING" ]; then
	PROJECT_SCALING_OPTION="${PROJECT_SCALING_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

ROTATION="$XSERVER_ROTATION"
CALIBRATE="no"

case "$BRIGHTNESS" in
    100)
	BRIGHTNESS="high"
	;;
    50)
	BRIGHTNESS="middle"
	;;
    10)
	BRIGHTNESS="low"
	;;
esac

BRIGHTNESS_LIST="high middle low"
BRIGHTNESS_OPTION="<OPTION>${BRIGHTNESS}<\/OPTION>"

IFS=' '
for i in ${BRIGHTNESS_LIST}; do
    if [ "$i" != "$BRIGHTNESS" ]; then
	BRIGHTNESS_OPTION="${BRIGHTNESS_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

ROTATION_LIST="0 90 180 270"
ROTATION_OPTION="<OPTION>${ROTATION}<\/OPTION>"

IFS=' '
for i in ${ROTATION_LIST}; do
    if [ "$i" != "$ROTATION" ]; then
	ROTATION_OPTION="${ROTATION_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

case "$XSERVER_CURSOR" in
    hand2)
	CURSOR="hand"
	;;
    shuttle)
	CURSOR="none"
	;;
    *)
	CURSOR="$XSERVER_CURSOR"
	;;
esac

CURSOR_LIST="X_cursor crosshair target arrow hand spider star dot none"
CURSOR_OPTION="<OPTION>${CURSOR}<\/OPTION>"

IFS=' '
for i in ${CURSOR_LIST}; do
    if [ "$i" != "$CURSOR" ]; then
	CURSOR_OPTION="${CURSOR_OPTION}<OPTION>${i}<\/OPTION>"
    fi
done

if [ "$MINIBROWSER" ]; then
    SCRSAVER="$SCRSAVER`echo min`"

    echo "CALIBRATE=$CALIBRATE"
    echo "SCRSAVER=$SCRSAVER"
    echo "BRIGHTNESS=$BRIGHTNESS"
    echo "DIALOG_THEME=$DIALOG_THEME"
    echo "PROJECT_SCALING=$PROJECT_SCALING"
    echo "ROTATION=$ROTATION"
    echo "CURSOR=$CURSOR"
else
    LOGOUT_REF=""

    if [ "$PASSWORD_MB" ]; then
	LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
    fi

    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$SCRSAVER'/"$SCRSAVER"/g | sed s/'$BRIGHTNESS_OPTION'/"$BRIGHTNESS_OPTION"/g \
		   | sed s/'$DIALOG_THEME_OPTION'/"$DIALOG_THEME_OPTION"/g | sed s/'$PROJECT_SCALING_OPTION'/"$PROJECT_SCALING_OPTION"/g \
		   | sed s/'$ROTATION_OPTION'/"$ROTATION_OPTION"/g | sed s/'$CURSOR_OPTION'/"$CURSOR_OPTION"/g
fi
