#!/bin/sh

HTML_PAGE="/var/www/setup_display.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

SCRSAVER="`xset -display :0 q | grep timeout | sed s/'^.*t:  '/''/ | sed s/' .*'/''/`"
SCRSAVER="`expr $SCRSAVER \/ 60`"
BRIGHTNESS="`/sbin/setlcd -i | grep 'Brightness' | sed s/'^.*s: '/''/`"
CALIBRATE="no"

case "$SCRSAVER" in
    0)
	SCRSAVER_OPTION="<OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    5)
	SCRSAVER_OPTION="<OPTION>5min<\/OPTION><OPTION>off<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    15)
	SCRSAVER_OPTION="<OPTION>15min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    30)
	SCRSAVER_OPTION="<OPTION>30min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
    60)
	SCRSAVER_OPTION="<OPTION>60min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION>"
	;;
    *)
	SCRSAVER_OPTION="<OPTION>$SCRSAVER\min<\/OPTION><OPTION>off<\/OPTION><OPTION>5min<\/OPTION><OPTION>15min<\/OPTION><OPTION>30min<\/OPTION><OPTION>60min<\/OPTION>"
	;;
esac

case "$BRIGHTNESS" in
    128)
	BRIGHTNESS="high"
	;;
    32)
	BRIGHTNESS="middle"
	;;
    8)
	BRIGHTNESS="low"
	;;
esac

case "$BRIGHTNESS" in
    high)
	BRIGHTNESS_OPTION="<OPTION>high<\/OPTION><OPTION>middle<\/OPTION><OPTION>low<\/OPTION>"
	;;
    middle)
	BRIGHTNESS_OPTION="<OPTION>middle<\/OPTION><OPTION>high<\/OPTION><OPTION>low<\/OPTION>"
	;;
    low)
	BRIGHTNESS_OPTION="<OPTION>low<\/OPTION><OPTION>high<\/OPTION><OPTION>middle<\/OPTION>"
	;;
esac

SCRSAVER="$SCRSAVER`echo min`"

if [ "$MINIBROWSER" ]; then
    echo "CALIBRATE=$CALIBRATE"
    echo "SCRSAVER=$SCRSAVER"
    echo "BRIGHTNESS=$BRIGHTNESS"
else
    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed s/'$SCRSAVER_OPTION'/"$SCRSAVER_OPTION"/g | sed s/'$BRIGHTNESS_OPTION'/"$BRIGHTNESS_OPTION"/g
fi
