#!/bin/sh

HTML_PAGE="../setup_update.html"

#echo "Content-type: text/html"
#echo

#for i in `env | sed s/' '/'%'/g`; do
#    echo "<p>$i</p>" | sed s/'%'/' '/g
#done

UPDATE_DIR="/tmp/update"

COLOR="#000000"

CONTENT_ID=`echo $CONTENT_TYPE | sed s/'^.*boundary=-*'//`

/sbin/cgidump -i $CONTENT_ID -s $CONTENT_LENGTH -d $UPDATE_DIR #> $UPDATE_DIR/cgidump.log 2>&1

#dd bs=$CONTENT_LENGTH count=1 > $UPDATE_DIR/content.dump 2>&1

STATUS="$?"

if [ "$STATUS" != "0" ]; then
    COLOR="#FF0000"
    MESSAGE="Upload error!"
else
    if [ "`ls $UPDATE_DIR/[0-9]*_update.tgz 2>/dev/null`" ]; then
	FWUPDATE_ERR=`/sbin/fwupdate 2>&1`

	STATUS="$?"

	echo "$FWUPDATE_ERR" > /var/log/update.log

	FWUPDATE_ERR=`echo "$FWUPDATE_ERR" | grep "\[" | sed s/'\['/''/g | sed s/'\]'/''/g`
    else
        STATUS="1"

        FWUPDATE_ERR="Wrong firmware file: `ls $UPDATE_DIR`"
    fi

    if [ "$STATUS" != "0" ]; then
	COLOR="#FF0000"
        MESSAGE="Upgrade error!<P>$FWUPDATE_ERR<\P>"
    else
	MESSAGE="Upgrade was successful."
    fi
fi

export MESSAGE="$MESSAGE"
export COLOR="$COLOR"

sh setup_update.cgi
