#! /bin/sh -e
#
### BEGIN INIT INFO
# Provides:          sysinit
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
### END INIT INFO

TMP_ROOT_DIR="/tmp/.root"

mount /proc
mount /tmp

echo -n "Restoring temporary directories..."

    cp -a /etc/backup/. $TMP_ROOT_DIR

    dmesg > $TMP_ROOT_DIR/var/log/dmesg

    mkdir /tmp/update

    mount /mnt/flash

echo "done."

SETLCD="/sbin/setlcd"

/sbin/modprobe i2c-adap-pxa
/sbin/modprobe i2c-proc

/sbin/modprobe ide-cs

/sbin/insmod /lib/modules/"$(uname -r)"/kernel/drivers/ide/ide-probe-mod.o

HWNUM="`mbinfo | grep \"HWString\" | sed s/'^.*H0'//`"

if [ $(($HWNUM > 200)) == 1 ]; then
    /sbin/modprobe tsc2046-ts
else
    /sbin/modprobe ucb1x00-ts
fi

IDSTRING="`/sbin/mbinfo 2>&1 | grep \"IdentString\" | sed s/'^.* : '// | sed s/' '//g`"

if [ ! "$IDSTRING" ]; then
    IDSTRING="UNKNOWN"
fi

. /etc/default/display

#modprobe pxafb options=`echo $video | sed s/'pxafb:'//` >/dev/null 2>&1

#fbset -pixclock 40000

cpufreq max >/dev/null 2>&1

echo -n "Setting display..."

    case "$DISPLAY_BRIGHTNESS" in
	high)
	    $SETLCD -s 128 256
	    ;;
	middle)
	    $SETLCD -s 32 256
	    ;;
	low)
	    $SETLCD -s 8 256
	    ;;
    esac

echo "done."

echo -n "Starting backlight monitor..."

    bkloop >/dev/null 2>&1 &

echo "done."

echo -n "Setting hostname..."

    echo "$IDSTRING" > $TMP_ROOT_DIR/etc/hostname

echo "done."

echo -n "Starting bootsplash..."

    mkdir /tmp/bootsplash

    case "$IDSTRING" in
	"ID-18")
#	    ln -s /etc/bootsplash/id-18-start.jpg /tmp/bootsplash/id-start.jpg
#	    ln -s /etc/bootsplash/id-18-halt.jpg /tmp/bootsplash/id-halt.jpg
	    ;;
	"ID-28")
#    	    ln -s /etc/bootsplash/id-28-start.jpg /tmp/bootsplash/id-start.jpg
#    	    ln -s /etc/bootsplash/id-28-halt.jpg /tmp/bootsplash/id-halt.jpg
	    ;;
	*)
#    	    ln -s /etc/bootsplash/unknown-start.jpg /tmp/bootsplash/id-start.jpg
#    	    ln -s /etc/bootsplash/unknown-halt.jpg /tmp/bootsplash/id-halt.jpg
	    ;;
    esac

    echo -en '\033[?1c' >/dev/tty0

    /etc/init.d/bootsplash.sh

echo "done."

echo -n "Prepare desktop background..."

    mkdir /tmp/pixmaps

    case "$IDSTRING" in
	"ID-18")
	    ln -s /usr/share/pixmaps/background-id-18.jpg /tmp/pixmaps/background.jpg
	    ;;
	"ID-28")
	    ln -s /usr/share/pixmaps/background-id-28.jpg /tmp/pixmaps/background.jpg
	    ;;
	*)
	    ln -s /usr/share/pixmaps/background-unknown.jpg /tmp/pixmaps/background.jpg
	    ;;
    esac

echo "done."

echo -n "Starting Xserver..."

    export HOME=/root

    cd $HOME

    xloop >/dev/null 2>&1 &

echo "done."

exit 0
