#!/bin/sh

if [ ! "$MINIBROWSER" ]; then
. auth.cgi
fi

HTML_PAGE="../setup_network.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

NET_DEVICE="eth0"

NET_CONFIG="/etc/network/interfaces"
DNS_CONFIG="/etc/resolv.conf"
MIB_CONFIG="/opt/MiniBrowser/MiniBrowser.ini"

if [ "`cat $NET_CONFIG | grep "iface $NET_DEVICE inet static"`" ]; then
    DHCP_OPTION="<OPTION>no<\/OPTION><OPTION>yes<\/OPTION>"
    DHCP="no"
else
    DHCP_OPTION="<OPTION>yes<\/OPTION><OPTION>no<\/OPTION>"
    DHCP="yes"
fi

if [ "`/sbin/ifconfig $NET_DEVICE | grep UP`" ]; then
    IP_ADDR="`/sbin/ifconfig $NET_DEVICE | sed s/' '/'\n'/g | grep 'addr:' | sed s/'addr:'/''/`"
    MASK_ADDR="`/sbin/ifconfig $NET_DEVICE | sed s/' '/'\n'/g | grep 'Mask:' | sed s/'Mask:'/''/`"
fi

MAC_ADDR="`/sbin/ifconfig $NET_DEVICE | grep 'HWaddr' | sed s/'^.*HWaddr '//`"

if [ "$MAC_ADDR" = "" ]; then
    MAC_ADDR="00:00:00:00:00:00"
fi

PLC_ADDR="`cat $MIB_CONFIG | sed '/^\[plc\]/,/ip/!d' | grep 'ip' | sed s/'^.*= '/''/`"

if [ "$PLC_ADDR" = "" ]; then
    PLC_ADDR="0.0.0.0"
fi

PLCCOMS_ADDR="`cat $MIB_CONFIG | sed '/^\[server\]/,/port/!d' | grep 'ip' | sed s/'^.*= '/''/`"

if [ "$PLCCOMS_ADDR" = "" ]; then
    PLCCOMS_ADDR="0.0.0.0"
fi

PLCCOMS_PORT="`cat $MIB_CONFIG | sed '/^\[server\]/,/port/!d' | grep 'port' | sed s/'^.*= '/''/`"

if [ "$PLCCOMS_PORT" = "" ]; then
    PLCCOMS_PORT="0"
fi

GW_ADDR="`/sbin/route -n | grep '^0.0.0.0' | grep $NET_DEVICE | awk '{print $2}'`"

PLC_IP_1="`echo $PLC_ADDR | sed s/'\.'/' '/g | awk '{print $1}'`"
PLC_IP_2="`echo $PLC_ADDR | sed s/'\.'/' '/g | awk '{print $2}'`"
PLC_IP_3="`echo $PLC_ADDR | sed s/'\.'/' '/g | awk '{print $3}'`"
PLC_IP_4="`echo $PLC_ADDR | sed s/'\.'/' '/g | awk '{print $4}'`"

PLCCOMS_IP_1="`echo $PLCCOMS_ADDR | sed s/'\.'/' '/g | awk '{print $1}'`"
PLCCOMS_IP_2="`echo $PLCCOMS_ADDR | sed s/'\.'/' '/g | awk '{print $2}'`"
PLCCOMS_IP_3="`echo $PLCCOMS_ADDR | sed s/'\.'/' '/g | awk '{print $3}'`"
PLCCOMS_IP_4="`echo $PLCCOMS_ADDR | sed s/'\.'/' '/g | awk '{print $4}'`"

PLCCOMS_PORT="`echo $PLCCOMS_PORT | sed s/'\.'/' '/g | awk '{print $1}'`"

IP_1="`echo $IP_ADDR | sed s/'\.'/' '/g | awk '{print $1}'`"
IP_2="`echo $IP_ADDR | sed s/'\.'/' '/g | awk '{print $2}'`"
IP_3="`echo $IP_ADDR | sed s/'\.'/' '/g | awk '{print $3}'`"
IP_4="`echo $IP_ADDR | sed s/'\.'/' '/g | awk '{print $4}'`"

MASK_1="`echo $MASK_ADDR | sed s/'\.'/' '/g | awk '{print $1}'`"
MASK_2="`echo $MASK_ADDR | sed s/'\.'/' '/g | awk '{print $2}'`"
MASK_3="`echo $MASK_ADDR | sed s/'\.'/' '/g | awk '{print $3}'`"
MASK_4="`echo $MASK_ADDR | sed s/'\.'/' '/g | awk '{print $4}'`"

GW_1="`echo $GW_ADDR | sed s/'\.'/' '/g | awk '{print $1}'`"
GW_2="`echo $GW_ADDR | sed s/'\.'/' '/g | awk '{print $2}'`"
GW_3="`echo $GW_ADDR | sed s/'\.'/' '/g | awk '{print $3}'`"
GW_4="`echo $GW_ADDR | sed s/'\.'/' '/g | awk '{print $4}'`"

DNS1="`cat $DNS_CONFIG | grep '^nameserver' | awk '{print $2}' | sed '2,2d'`"
DNS2="`cat $DNS_CONFIG | grep '^nameserver' | awk '{print $2}' | sed '1,1d'`"

DNS1_1="`echo $DNS1 | sed s/'\.'/' '/g | awk '{print $1}'`"
DNS1_2="`echo $DNS1 | sed s/'\.'/' '/g | awk '{print $2}'`"
DNS1_3="`echo $DNS1 | sed s/'\.'/' '/g | awk '{print $3}'`"
DNS1_4="`echo $DNS1 | sed s/'\.'/' '/g | awk '{print $4}'`"

DNS2_1="`echo $DNS2 | sed s/'\.'/' '/g | awk '{print $1}'`"
DNS2_2="`echo $DNS2 | sed s/'\.'/' '/g | awk '{print $2}'`"
DNS2_3="`echo $DNS2 | sed s/'\.'/' '/g | awk '{print $3}'`"
DNS2_4="`echo $DNS2 | sed s/'\.'/' '/g | awk '{print $4}'`"

if [ "$MINIBROWSER" ]; then
    echo "DHCP=$DHCP"
    echo "IF=$NET_DEVICE"
    echo "MAC=$MAC_ADDR"
    echo "IP_1=$IP_1"
    echo "IP_2=$IP_2"
    echo "IP_3=$IP_3"
    echo "IP_4=$IP_4"
    echo "MASK_1=$MASK_1"
    echo "MASK_2=$MASK_2"
    echo "MASK_3=$MASK_3"
    echo "MASK_4=$MASK_4"
    echo "GW_1=$GW_1"
    echo "GW_2=$GW_2"
    echo "GW_3=$GW_3"
    echo "GW_4=$GW_4"
    echo "DNS1_1=$DNS1_1"
    echo "DNS1_2=$DNS1_2"
    echo "DNS1_3=$DNS1_3"
    echo "DNS1_4=$DNS1_4"
    echo "DNS2_1=$DNS2_1"
    echo "DNS2_2=$DNS2_2"
    echo "DNS2_3=$DNS2_3"
    echo "DNS2_4=$DNS2_4"
else
    LOGOUT_REF=""

    if [ "$PASSWORD_MB" ]; then
	LOGOUT_REF="                        \<A href=\"setup_logout.cgi\" title=\"Logout\"\>Logout\<\/A\>"
    fi

    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed /"setup_logout.cgi"/s/"^.*$"/"$LOGOUT_REF"/ | sed s/'$DHCP_OPTION'/"$DHCP_OPTION"/g \
    		   | sed s/'$PLC_IP_1'/"$PLC_IP_1"/g | sed s/'$PLC_IP_2'/"$PLC_IP_2"/g | sed s/'$PLC_IP_3'/"$PLC_IP_3"/g | sed s/'$PLC_IP_4'/"$PLC_IP_4"/g \
    		   | sed s/'$PLCCOMS_IP_1'/"$PLCCOMS_IP_1"/g | sed s/'$PLCCOMS_IP_2'/"$PLCCOMS_IP_2"/g | sed s/'$PLCCOMS_IP_3'/"$PLCCOMS_IP_3"/g | sed s/'$PLCCOMS_IP_4'/"$PLCCOMS_IP_4"/g \
    		   | sed s/'$PLCCOMS_PORT'/"$PLCCOMS_PORT"/g \
    		   | sed s/'$IP_1'/"$IP_1"/g | sed s/'$IP_2'/"$IP_2"/g | sed s/'$IP_3'/"$IP_3"/g | sed s/'$IP_4'/"$IP_4"/g \
    		   | sed s/'$MASK_1'/"$MASK_1"/g | sed s/'$MASK_2'/"$MASK_2"/g | sed s/'$MASK_3'/"$MASK_3"/g | sed s/'$MASK_4'/"$MASK_4"/g \
    		   | sed s/'$GW_1'/"$GW_1"/g | sed s/'$GW_2'/"$GW_2"/g | sed s/'$GW_3'/"$GW_3"/g | sed s/'$GW_4'/"$GW_4"/g \
    		   | sed s/'$DNS1_1'/"$DNS1_1"/g | sed s/'$DNS1_2'/"$DNS1_2"/g | sed s/'$DNS1_3'/"$DNS1_3"/g | sed s/'$DNS1_4'/"$DNS1_4"/g \
    		   | sed s/'$DNS2_1'/"$DNS2_1"/g | sed s/'$DNS2_2'/"$DNS2_2"/g | sed s/'$DNS2_3'/"$DNS2_3"/g | sed s/'$DNS2_4'/"$DNS2_4"/g
fi
